/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc;

import com.ferreusveritas.dynamictrees.api.seasons.ISeasonManager;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TFCSeasonManager
implements ISeasonManager {
    public static final TFCSeasonManager INSTANCE = new TFCSeasonManager();

    public void updateTick(World world, long worldTicks) {
    }

    public void flushMappings() {
    }

    public float getGrowthFactor(World world, BlockPos rootPos, float offset) {
        return this.getMonthModifier(CalendarTFC.CALENDAR_TIME.getMonthOfYear());
    }

    public float getSeedDropFactor(World world, BlockPos rootPos, float offset) {
        return this.getMonthModifier(CalendarTFC.CALENDAR_TIME.getMonthOfYear()) + 0.05f;
    }

    public float getFruitProductionFactor(World world, BlockPos rootPos, float offset) {
        float mod = this.getMonthModifier(CalendarTFC.CALENDAR_TIME.getMonthOfYear());
        return mod < 0.25f ? 0.0f : mod;
    }

    public Float getSeasonValue(World world, BlockPos blockPos) {
        return Float.valueOf((float)Math.min((double)(this.getMonthModifier(CalendarTFC.CALENDAR_TIME.getMonthOfYear().next().next().next()) * 4.0f), 3.999));
    }

    public boolean isTropical(World world, BlockPos blockPos) {
        return ClimateTFC.getRainfall((World)world, (BlockPos)blockPos) > 300.0f && ClimateTFC.getAvgTemp((World)world, (BlockPos)blockPos) > 20.0f;
    }

    public boolean shouldSnowMelt(World world, BlockPos blockPos) {
        return ClimateTFC.getDailyTemp((World)world, (BlockPos)blockPos) > 0.0f;
    }

    private float getMonthModifier(Month month) {
        return 1.0f - (month.getTemperatureModifier() - 27.0f) / 66.5f;
    }
}

